using UnityEngine;
using System.Collections;

public class BankLine : MonoBehaviour {
	
	public ShoreMover bankShoreLeft;
	public ShoreMover bankShoreRight;
	public GameObject bankLine;
	public Texture bankTextureLeft;
	public Texture bankTextureRight;
	public Texture mainTextureLeft;
	public Texture mainTextureRight;
	public Texture finishTexture;
	public float timeSinceBank = 0.0f;
	public float timeBetweenBanks = 10.0f;
	public float gameDuration = 300.0f;
	private bool isShowingBank = false;
	private bool hasBankCycled = false;
	

	// Use this for initialization
	void Start () {
	}
	
	// Update is called once per frame
	void Update () {
		
		if (isShowingBank){
			if (bankShoreLeft.transform.position.y < 0.0f) {
				hasBankCycled = true;
			}
			if (hasBankCycled && bankShoreLeft.transform.position.y > 18.0f) {
//				if (Time.time > gameDuration) {
//					gameObject.renderer.material.mainTexture = finishTexture;
//				}
				bankShoreLeft.gameObject.renderer.material.mainTexture = mainTextureLeft;
				bankShoreRight.gameObject.renderer.material.mainTexture = mainTextureRight;
				gameObject.renderer.enabled = false;
				gameObject.collider.enabled = false;
				hasBankCycled = false;
				isShowingBank = false;
			}
		} else{ 
			timeSinceBank += Time.deltaTime;
			if (timeSinceBank > timeBetweenBanks && bankShoreLeft.transform.position.y > 18.0f ) {
				mainTextureLeft = bankShoreLeft.gameObject.renderer.material.mainTexture;
				mainTextureRight = bankShoreRight.gameObject.renderer.material.mainTexture;
				bankShoreLeft.gameObject.renderer.material.mainTexture = bankTextureLeft;
				bankShoreRight.gameObject.renderer.material.mainTexture = bankTextureRight;
				gameObject.renderer.enabled = true;
				gameObject.collider.enabled = true;
				Debug.Log("Showing bank!");
				isShowingBank = true;
				timeSinceBank = 0.0f;
			}
		}
	}
}
